﻿using System;

namespace KursBeispiele
{
    //Statische Klasse können nur statische Methoden beinhalten
    //Normale Klasse können beides (statische und nicht-statische) beinhalten
    static class Program
    {
        static void Main(string[] args)
        {
            //Abstrakte Klassen können nicht instanziieren werden!
            //Bauplan bau = new Bauplan();

            //Aber (da Bauplan Oberklasse ist) können als Typen verwendet werden
            Bauplan bau = new Implementierung();
            bau.Funktion();

            bau = new InterfaceKlasse();
            //Geht natürlich auch - da der Typ nach wie vor Bauplan ist und InterfaceKlasse davon erbt
            bau.Funktion();

            //Analog zur Abstrakten Klasse sind keine Instanzen von Schnittstellen möglich - aber natürlich Typen!
            (bau as SchnittstelleEins).FunktionEins(); //<-- Beschränkt auf SchnittstelleEins Möglichkeiten
            SchnittstelleZwei schnitt = bau as SchnittstelleZwei; //<-- Beschränkt auf die Möglichkeiten von Sch..Zwei
            schnitt.FunktionZwei();

            InterfaceKlasse ik1 = new InterfaceKlasse();
            InterfaceKlasse ik2 = new InterfaceKlasse();
            
            Console.Read();
        }
    }

    //abstract bei Klasse: kann nicht instanziiert werden
    public abstract class Bauplan
    {
        //abstract bei Methode (Eigenschaften, Delegaten, ...): muss implementiert werden - a la Prototypen in C
        public abstract void Funktion();
    }

    class Implementierung : Bauplan
    {
        //Diese Funktion MUSS implementiert werden - ansonsten Compiler-Fehler
        public override void Funktion()
        {
            Console.WriteLine("Das bin ich!");
        }
    }

    public interface SchnittstelleEins
    {
        //Jede Interface Funktion ist automatisch ein Prototyp und besitzt automatisch den Interface Modifizierer!
        void FunktionEins();
    }

    public interface SchnittstelleZwei
    {
        //Jede Interface Funktion ist automatisch ein Prototyp und besitzt automatisch den Interface Modifizierer!
        void FunktionZwei();
    }

    //Wir dürfen von [0..1] Klasse und [0..n] Schnittstellen erben
    class InterfaceKlasse : Bauplan, SchnittstelleEins, SchnittstelleZwei
    {
        //Statische Konstruktoren brauchen keinen Modifizierer - analog zu Destruktoren
        static InterfaceKlasse() //da wir statisch sind können wir nicht über : this() auf eine (Konstruktor-)Instanz zugreifen!
        {
            //Wird nur einmal ausgeführt: Wenn zum ersten mal eine Instanz gebildet wird
            Console.WriteLine("Static: I've been called!");
            new InterfaceKlasse(true);
        }

        private InterfaceKlasse(bool staticCalled)
        {
            Console.WriteLine("Privater Konstruktor wurde aufgerufen - und zwar von " + (staticCalled ? "static." : "non-static!"));
        }

        public InterfaceKlasse() : this(false)
        {
            Console.WriteLine("Non-Static has been called!");
        }

        public void FunktionZwei()
        {
            Console.WriteLine("Hallo!");
        }

        public void FunktionEins()
        {
            Console.WriteLine("Huhu!");
        }

        public override void Funktion()
        {
            Console.WriteLine("Hoide!");
        }
    }

}